<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Photo extends Model
{
    protected $fillable = [
        'annonce_id',
        'chemin',
        'nom_original',
        'taille',
        'type_mime',
        'ordre',
        'est_principale',
    ];

    protected $casts = [
        'est_principale' => 'boolean',
        'taille' => 'integer',
        'ordre' => 'integer',
    ];

    /**
     * Relation avec l'annonce
     */
    public function annonce(): BelongsTo
    {
        return $this->belongsTo(Annonce::class);
    }

    /**
     * Obtenir l'URL complète de la photo
     */
    public function getUrlAttribute(): string
    {
        return asset('storage/' . $this->chemin);
    }
}
