<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Middleware global pour logger toutes les requêtes API
        // FixAuthorizationHeader doit être AVANT LogAllRequests pour que les logs montrent le header corrigé
        $middleware->api(prepend: [
            \App\Http\Middleware\FixAuthorizationHeader::class,
            \App\Http\Middleware\LogAllRequests::class,
        ]);
        
        $middleware->alias([
            'log.sanctum' => \App\Http\Middleware\LogSanctumToken::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
