<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('alertes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('nom_alerte');
            $table->enum('type_bien', ['appartement', 'maison', 'studio', 'villa', 'terrain', 'bureau', 'commerce'])->nullable();
            $table->enum('statut', ['vente', 'location'])->nullable();
            $table->string('ville')->nullable();
            $table->string('quartier')->nullable();
            $table->decimal('prix_min', 15, 2)->nullable();
            $table->decimal('prix_max', 15, 2)->nullable();
            $table->decimal('superficie_min', 8, 2)->nullable();
            $table->decimal('superficie_max', 8, 2)->nullable();
            $table->integer('nombre_pieces_min')->nullable();
            $table->integer('nombre_pieces_max')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('alertes');
    }
};
