<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users = [
            [
                'name' => 'Super Admin',
                'email' => 'admin@immo.com',
                'password' => Hash::make('password'),
                'numero' => '+237123456789',
                'role_id' => 1, // super_admin
                'is_active' => true,
            ],
            [
                'name' => 'Jean Dupont',
                'email' => 'locataire@immo.com',
                'password' => Hash::make('password'),
                'numero' => '+237123456790',
                'role_id' => 3, // acheteur_locataire
                'is_active' => true,
            ],
            [
                'name' => 'Marie Martin',
                'email' => 'propretaire@immo.com',
                'password' => Hash::make('password'),
                'numero' => '+237123456791',
                'role_id' => 4, // vendeur_proprietaire
                'is_active' => true,
            ],
        ];

        foreach ($users as $user) {
            User::create($user);
        }
    }
}
