<?php

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\AnnonceController;
use App\Http\Controllers\Api\MessageController;
use App\Http\Controllers\Api\FavoriController;
use App\Http\Controllers\Api\AlerteController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\TypeBienController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Routes d'authentification (publiques)
Route::prefix('auth')->group(function () {
    Route::post('register', [AuthController::class, 'register']);
    Route::post('login', [AuthController::class, 'login']);
    Route::post('login-phone', [AuthController::class, 'loginWithPhone']);
    Route::post('login-google', [AuthController::class, 'loginWithGoogle']);
    Route::post('login-facebook', [AuthController::class, 'loginWithFacebook']);
});

// Routes protégées par authentification
Route::middleware(['log.sanctum', 'auth:sanctum'])->group(function () {
    
    // Authentification
    Route::prefix('auth')->group(function () {
        Route::post('logout', [AuthController::class, 'logout']);
        Route::get('me', [AuthController::class, 'me']);
    });

    // Profil utilisateur
    Route::prefix('user')->group(function () {
        Route::get('profile', [UserController::class, 'profile']);
        Route::match(['put', 'post'], 'profile', [UserController::class, 'updateProfile']); // POST accepté pour _method=PUT
        Route::post('profile-photo', [UserController::class, 'updateProfilePhoto']);
    });

    // Récupérer un utilisateur par son ID
    Route::get('users/{id}', [UserController::class, 'getUserById']);

    // Annonces
    Route::apiResource('annonces', AnnonceController::class)->except(['update']);
    Route::match(['put', 'post'], 'annonces/{id}', [AnnonceController::class, 'update']); // POST accepté pour _method=PUT
    Route::get('my-annonces', [AnnonceController::class, 'myAnnonces']);
    Route::get('annonces/{id}/stats', [AnnonceController::class, 'stats']);

    // Favoris
    Route::post('favoris', [FavoriController::class, 'store']);
    Route::match(['delete', 'post'], 'favoris/{id}', [FavoriController::class, 'destroy']); // POST accepté pour _method=DELETE
    Route::get('my-favoris', [FavoriController::class, 'myFavoris']);
    Route::get('favoris/check/{annonceId}', [FavoriController::class, 'checkFavori']);

    // Messages
    Route::get('my-messages', [MessageController::class, 'myMessages']);
    Route::get('conversations/{otherUserId}', [MessageController::class, 'getConversation']);
    Route::post('messages', [MessageController::class, 'store']);
    Route::post('messages/{id}/read', [MessageController::class, 'markAsRead']);
    Route::delete('messages/{id}', [MessageController::class, 'destroy']);
    Route::get('messages/unread-count', [MessageController::class, 'unreadCount']);

    // Alertes
    Route::apiResource('alertes', AlerteController::class);
    Route::get('my-alertes', [AlerteController::class, 'myAlertes']);
});

// Routes publiques pour les annonces (lecture seule)
Route::get('annonces', [AnnonceController::class, 'index']);
Route::get('annonces/{id}', [AnnonceController::class, 'show']);
Route::get('type-biens', [TypeBienController::class, 'index']);
