# 🏠 Immo Backend - API Laravel

API backend pour une application mobile de mise en relation immobilière entre vendeurs/propriétaires et acheteurs/locataires.

## 🚀 Installation

### Prérequis
- PHP 8.2+
- Composer
- SQLite (ou MySQL/PostgreSQL)

### Configuration

1. **Cloner le projet**
```bash
git clone <repository-url>
cd immo-backend
```

2. **Installer les dépendances**
```bash
composer install
```

3. **Configuration de l'environnement**
```bash
cp .env.example .env
php artisan key:generate
```

4. **Configuration de la base de données**
- Par défaut, le projet utilise SQLite
- Le fichier `database/database.sqlite` est déjà créé
- Pour utiliser MySQL/PostgreSQL, modifiez le fichier `.env`

5. **Exécuter les migrations et seeders**
```bash
php artisan migrate
php artisan db:seed
```

6. **Créer le lien symbolique pour le stockage**
```bash
php artisan storage:link
```

7. **Démarrer le serveur**
```bash
php artisan serve
```

L'API sera accessible sur `http://localhost:8000/api`

## 📡 Endpoints API

### Authentification
- `POST /api/auth/register` - Inscription
- `POST /api/auth/login` - Connexion
- `POST /api/auth/login-phone` - Connexion par téléphone
- `POST /api/auth/logout` - Déconnexion
- `GET /api/auth/me` - Profil utilisateur

### Annonces
- `GET /api/annonces` - Liste des annonces (avec filtres)
- `POST /api/annonces` - Créer une annonce
- `GET /api/annonces/{id}` - Détails d'une annonce
- `PUT /api/annonces/{id}` - Modifier une annonce
- `DELETE /api/annonces/{id}` - Supprimer une annonce
- `GET /api/my-annonces` - Mes annonces
- `GET /api/annonces/{id}/stats` - Statistiques d'une annonce

### Favoris
- `GET /api/favoris` - Mes favoris
- `POST /api/favoris` - Ajouter aux favoris
- `DELETE /api/favoris/{id}` - Retirer des favoris

### Messages
- `GET /api/messages` - Mes messages
- `POST /api/messages` - Envoyer un message
- `POST /api/messages/{id}/read` - Marquer comme lu

### Alertes
- `GET /api/alertes` - Mes alertes
- `POST /api/alertes` - Créer une alerte
- `PUT /api/alertes/{id}` - Modifier une alerte
- `DELETE /api/alertes/{id}` - Supprimer une alerte

## 👥 Rôles utilisateurs

1. **Super Admin** (ID: 1) - Accès complet
2. **Admin** (ID: 2) - Gestion et modération
3. **Acheteur/Locataire** (ID: 3) - Consultation et contact
4. **Vendeur/Propriétaire** (ID: 4) - Création d'annonces

## 🔐 Authentification

L'API utilise Laravel Sanctum pour l'authentification par token.

### Headers requis pour les routes protégées :
```
Authorization: Bearer {token}
Content-Type: application/json
Accept: application/json
```

## 📊 Utilisateurs de test

Après avoir exécuté les seeders, vous pouvez utiliser ces comptes :

- **Super Admin**: `admin@immo.com` / `password`
- **Acheteur**: `jean.dupont@example.com` / `password`
- **Vendeur**: `marie.martin@example.com` / `password`

## 🗂️ Structure de la base de données

- **users** - Utilisateurs avec rôles
- **roles** - Rôles système
- **annonces** - Annonces immobilières
- **photos** - Photos des annonces
- **favoris** - Annonces favorites des utilisateurs
- **messages** - Messages entre utilisateurs et vendeurs
- **alertes** - Alertes personnalisées des utilisateurs

## 📝 Filtres disponibles pour les annonces

- `type_bien` - Type de bien (appartement, maison, studio, etc.)
- `statut` - Vente ou location
- `ville` - Ville
- `prix_min` / `prix_max` - Fourchette de prix
- `superficie_min` / `superficie_max` - Fourchette de superficie
- `nombre_pieces` - Nombre de pièces

## 🚀 Déploiement

Pour le déploiement en production :

1. Modifiez le fichier `.env` avec vos paramètres de production
2. Configurez votre base de données
3. Exécutez les migrations et seeders
4. Configurez votre serveur web (Apache/Nginx)
5. Activez HTTPS

## 📱 Intégration Mobile

Cette API est conçue pour être utilisée avec une application Flutter. 
Consultez le projet Flutter associé pour l'implémentation mobile.