<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Alerte extends Model
{
    protected $fillable = [
        'user_id',
        'nom_alerte',
        'type_bien',
        'statut',
        'ville',
        'quartier',
        'prix_min',
        'prix_max',
        'superficie_min',
        'superficie_max',
        'nombre_pieces_min',
        'nombre_pieces_max',
        'active',
    ];

    protected $casts = [
        'prix_min' => 'decimal:2',
        'prix_max' => 'decimal:2',
        'superficie_min' => 'decimal:2',
        'superficie_max' => 'decimal:2',
        'active' => 'boolean',
    ];

    /**
     * Relation avec l'utilisateur
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Scope pour les alertes actives
     */
    public function scopeActive($query)
    {
        return $query->where('active', true);
    }
}
