<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('annonces', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('titre');
            $table->text('description');
            // Optionnel: relation vers table type_biens (sans contrainte FK pour éviter l'ordre de migration)
            $table->unsignedBigInteger('type_bien_id')->nullable();
            $table->enum('statut', ['vente', 'location']);
            $table->string('ville');
            $table->string('quartier');
            $table->text('adresse');
            $table->decimal('prix', 15, 2);
            $table->decimal('superficie', 8, 2)->nullable();
            $table->integer('nombre_pieces')->nullable();
            $table->integer('nombre_chambres')->nullable();
            $table->integer('nombre_salles_bain')->nullable();
            $table->json('equipements')->nullable(); // Liste des équipements
            $table->enum('statut_annonce', ['active', 'inactive', 'vendue', 'louee'])->default('active');
            
            // Champs spécifiques aux terrains
            $table->string('situation_geographique')->nullable();
            $table->string('localisation_exacte')->nullable();
            $table->decimal('superficie_terrain', 8, 2)->nullable();
            $table->enum('type_terrain', ['urbain', 'agricole'])->nullable();
            $table->enum('statut_approbation', ['approuvé', 'non_approuvé'])->nullable();
            $table->enum('titre_propriete', ['attestation', 'ADU', 'ACD', 'certificat_foncier'])->nullable();
            
            // Statistiques
            $table->integer('nombre_vues')->default(0);
            $table->integer('nombre_favoris')->default(0);
            $table->integer('nombre_contacts')->default(0);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('annonces');
    }
};
