<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'name' => 'super_admin',
                'display_name' => 'Super Administrateur',
                'description' => 'Accès complet à toutes les fonctionnalités du système',
            ],
            [
                'name' => 'admin',
                'display_name' => 'Administrateur',
                'description' => 'Gestion des utilisateurs et modération des annonces',
            ],
            [
                'name' => 'acheteur_locataire',
                'display_name' => 'Acheteur / Locataire',
                'description' => 'Peut consulter les annonces, contacter les vendeurs et créer des alertes',
            ],
            [
                'name' => 'vendeur_proprietaire',
                'display_name' => 'Vendeur / Propriétaire',
                'description' => 'Peut créer et gérer ses annonces, voir les statistiques',
            ],
        ];

        foreach ($roles as $role) {
            Role::create($role);
        }
    }
}
