<?php

use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\AnnonceController;
use App\Http\Controllers\Api\MessageController;
use App\Http\Controllers\Api\FavoriController;
use App\Http\Controllers\Api\AlerteController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\TypeBienController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Routes d'authentification (publiques)
Route::prefix('auth')->group(function () {
    Route::post('register', [AuthController::class, 'register']);
    Route::post('login', [AuthController::class, 'login']);
    Route::post('login-phone', [AuthController::class, 'loginWithPhone']);
    Route::post('login-google', [AuthController::class, 'loginWithGoogle']);
    Route::post('login-facebook', [AuthController::class, 'loginWithFacebook']);
});

// Routes protégées par authentification
Route::middleware('auth:sanctum')->group(function () {
    
    // Authentification
    Route::prefix('auth')->group(function () {
        Route::post('logout', [AuthController::class, 'logout']);
        Route::get('me', [AuthController::class, 'me']);
    });

    // Profil utilisateur
    Route::prefix('user')->group(function () {
        Route::get('profile', [UserController::class, 'profile']);
        Route::put('profile', [UserController::class, 'updateProfile']);
        Route::post('profile-photo', [UserController::class, 'updateProfilePhoto']);
    });

    // Annonces
    Route::apiResource('annonces', AnnonceController::class);
    Route::get('my-annonces', [AnnonceController::class, 'myAnnonces']);
    Route::get('annonces/{id}/stats', [AnnonceController::class, 'stats']);

    // Favoris
    Route::post('favoris', [FavoriController::class, 'store']);
    Route::delete('favoris/{id}', [FavoriController::class, 'destroy']);
    Route::get('my-favoris', [FavoriController::class, 'myFavoris']);
    Route::get('favoris/check/{annonceId}', [FavoriController::class, 'checkFavori']);

    // Messages
    Route::apiResource('messages', MessageController::class);
    Route::get('my-messages', [MessageController::class, 'myMessages']);
    Route::post('messages/{id}/read', [MessageController::class, 'markAsRead']);

    // Alertes
    Route::apiResource('alertes', AlerteController::class);
    Route::get('my-alertes', [AlerteController::class, 'myAlertes']);
});

// Routes publiques pour les annonces (lecture seule)
Route::get('annonces', [AnnonceController::class, 'index']);
Route::get('annonces/{id}', [AnnonceController::class, 'show']);
Route::get('type-biens', [TypeBienController::class, 'index']);
